-- jeli funkcja o takiej nazwie ju istnieje to j usu
IF OBJECT_ID (N'dbo.GetProductMembersByParam') IS NOT NULL
   DROP FUNCTION dbo.GetProductMembersByParam
GO

-- utwrz funkcj przyjmujc trzy parametry i zwracajc jako wynik tabel
CREATE FUNCTION dbo.GetProductMembersByParam (@MEM_INFO VARCHAR(50), @INCLUDE_PARENT BIT, @NAME_OR_ID VARCHAR(4) )
RETURNS @ProductMembers TABLE 
(
	MEM_ID		INT NOT NULL,
	MEM_NAME	VARCHAR(50) NOT NULL,
	MEM_DESC	VARCHAR(255) NOT NULL,
	MEM_PID		INT NOT NULL
)
AS
BEGIN

	--  Jeli @parametr @INCLUDE_PARENT ma warto 1 
	--  to wstaw do tabeli rekord rodzica
	IF @INCLUDE_PARENT = 1
	BEGIN
		-- Jeli parameter @NAME_OR_ID ma warto NAME 
-- to szukaj elementu wg. Nazwy
		IF @NAME_OR_ID = 'NAME'
		BEGIN
			INSERT @ProductMembers
				SELECT MEM_ID, MEM_NAME, MEM_DESC, MEM_PID
				FROM PRODUCT_PC
				WHERE MEM_NAME = @MEM_INFO
		END
		ELSE
-- w przeciwynym wypadku szukaj elementu wg. identyfikatora
		BEGIN
			INSERT @ProductMembers
				SELECT MEM_ID, MEM_NAME, MEM_DESC, MEM_PID
				FROM PRODUCT_PC
				WHERE MEM_ID = CAST(@MEM_INFO AS INT)
		END
	END

	-- Wstaw wszystkie dzieci rodzica, 
	-- ktrego nazwa lub indetyfikator zosta okrelona w parametrze @MEM_INFO
		IF @NAME_OR_ID = 'NAME'
		-- jeli szukamy po nazwie
		BEGIN
			INSERT @ProductMembers
				SELECT MEM_ID, MEM_NAME, MEM_DESC, MEM_PID
				FROM PRODUCT_PC
				WHERE MEM_PID = (SELECT MEM_ID 
FROM PRODUCT_PC WHERE MEM_NAME = @MEM_INFO)
		END
		-- jeli szukamy po identyfikatorze
		ELSE
		BEGIN
			INSERT @ProductMembers
				SELECT MEM_ID, MEM_NAME, MEM_DESC, MEM_PID
				FROM PRODUCT_PC
				WHERE MEM_PID = (SELECT MEM_ID 
FROM PRODUCT_PC WHERE MEM_ID = CAST(@MEM_INFO AS INT))
		END
   RETURN
END
GO
